///////////////////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK TrayIconProc(HWND xWindowHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    TrayIcon_hWnd = xWindowHandle;

    while(1)
    {
        if(xMessage == WM_COMMAND)
        {
            if(LOWORD(wParam) == ID_Manager)
            {
                if(IsWindowVisible(JobManagerDialog_hWnd))
                    SetForegroundWindow(JobManagerDialog_hWnd);
                else DialogBox(MainInstance, MAKEINTRESOURCE(JobManager), NULL, JobManagerDialog);
            }

            if(LOWORD(wParam) == ID_Exit)
            {
                KillApplication();
            }

            break;
        }

        if(xMessage == WM_TIMECHANGE)
        {
            CalculateSchedules();
            break;
        }

        if(xMessage == WM_TIMER)
        {
            if(!Interval())
                KillTimer(TrayIcon_hWnd, 1);

            break;
        }

        if(xMessage == WM_CREATE)
        {
            TrayIcon_hWnd = xWindowHandle;
            TB_CREATED = RegisterWindowMessage("TaskbarCreated");
            SetTimer(xWindowHandle, 1, 1000, NULL);
            break;
        }

        if(xMessage == WM_SHELLNOTIFY)
        {
            if(lParam == WM_RBUTTONDOWN)
            {
                if(IsWindowVisible(TimeToRegisterDialog_hWnd))
                    break;

                GetCursorPos(&pt);
                SetForegroundWindow(xWindowHandle);
                TrackPopupMenuEx(FileMenu, TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x,pt.y, xWindowHandle, NULL);
                PostMessage(xWindowHandle, WM_NULL, 0, 0);
            }

            if(lParam == WM_LBUTTONDOWN)
            {
                if(IsWindowVisible(TimeToRegisterDialog_hWnd))
                    break;

                if(IsWindowVisible(JobManagerDialog_hWnd))
                    SetForegroundWindow(JobManagerDialog_hWnd);
                else DialogBox(MainInstance, MAKEINTRESOURCE(JobManager), NULL, JobManagerDialog);
            }

            break;
        }

        if(xMessage == WM_DESTROY)
        {
            UnregisterClass(TitleCaption, MainInstance);
            Shell_NotifyIconA(NIM_DELETE, &Note);
            PostQuitMessage(0);
            break;
        }

        if(xMessage == WM_CLOSE)
        {
            KillTimer(xWindowHandle, 1);
            DestroyWindow(xWindowHandle);
            break;
        }

        if(xMessage == TB_CREATED)
        {
            Shell_NotifyIcon(NIM_ADD, &Note);
        }

        break;

    }

    return DefWindowProc(xWindowHandle, xMessage, wParam, lParam);
}

///////////////////////////////////////////////////////////////////////////////////////////

